/*
 * Decompiled with CFR 0.152.
 */
package morph.avaritia.client.model;

import codechicken.lib.model.bakedmodels.WrappedItemModel;
import codechicken.lib.render.item.IItemRenderer;
import codechicken.lib.util.ArrayUtils;
import codechicken.lib.util.LambdaUtils;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Transformation;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import morph.avaritia.client.AvaritiaShaders;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.ItemModelGenerator;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.model.SimpleModelState;

public class CosmicBakedModel
extends WrappedItemModel
implements IItemRenderer {
    private final List<BakedQuad> maskQuads;
    private final ItemOverrides overrideList = new ItemOverrides(){

        public BakedModel m_173464_(BakedModel originalModel, ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity entity, int seed) {
            CosmicBakedModel.this.entity = entity;
            CosmicBakedModel.this.world = world == null ? (entity == null ? null : (ClientLevel)entity.f_19853_) : null;
            return CosmicBakedModel.this.wrapped.m_7343_().m_173464_(originalModel, stack, world, entity, seed);
        }
    };
    private static final ItemModelGenerator ITEM_MODEL_GENERATOR = new ItemModelGenerator();
    private static final FaceBakery FACE_BAKERY = new FaceBakery();

    public CosmicBakedModel(BakedModel wrapped, TextureAtlasSprite maskSprite) {
        super(wrapped);
        this.maskQuads = CosmicBakedModel.bakeItem(maskSprite);
    }

    public void renderItem(ItemStack stack, ItemTransforms.TransformType transformType, PoseStack pStack, MultiBufferSource source, int packedLight, int packedOverlay) {
        this.renderWrapped(stack, pStack, source, packedLight, packedOverlay, true);
        if (source instanceof MultiBufferSource.BufferSource) {
            MultiBufferSource.BufferSource bs = (MultiBufferSource.BufferSource)source;
            bs.m_109911_();
        }
        RenderType.CompositeRenderType cosmicRenderType = RenderType.m_173215_((String)"avaritia:cosmic", (VertexFormat)DefaultVertexFormat.f_85811_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)0x200000, (boolean)true, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(new RenderStateShard.ShaderStateShard(() -> AvaritiaShaders.cosmicShader)).m_110663_(RenderStateShard.f_110112_).m_110671_(RenderStateShard.f_110152_).m_110685_(RenderStateShard.f_110139_).m_173290_((RenderStateShard.EmptyTextureStateShard)RenderStateShard.f_110145_).m_110691_(true));
        float yaw = 0.0f;
        float pitch = 0.0f;
        float scale = 1.0f;
        if (transformType != ItemTransforms.TransformType.GUI) {
            Minecraft mc = Minecraft.m_91087_();
            yaw = (float)((double)(mc.f_91074_.m_146908_() * 2.0f) * Math.PI / 360.0);
            pitch = -((float)((double)(mc.f_91074_.m_146909_() * 2.0f) * Math.PI / 360.0));
        } else {
            scale = 25.0f;
        }
        if (AvaritiaShaders.cosmicOpacity != null) {
            AvaritiaShaders.cosmicOpacity.glUniform1f(1.0f);
        }
        AvaritiaShaders.cosmicYaw.glUniform1f(yaw);
        AvaritiaShaders.cosmicPitch.glUniform1f(pitch);
        AvaritiaShaders.cosmicExternalScale.glUniform1f(scale);
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        VertexConsumer cons = source.m_6299_((RenderType)cosmicRenderType);
        itemRenderer.m_115162_(pStack, cons, this.maskQuads, stack, packedLight, packedOverlay);
    }

    public ModelState getModelTransform() {
        return this.parentState;
    }

    public boolean m_7541_() {
        return this.wrapped.m_7541_();
    }

    public boolean m_7539_() {
        return this.wrapped.m_7539_();
    }

    public boolean m_7547_() {
        return this.wrapped.m_7547_();
    }

    public ItemOverrides m_7343_() {
        return this.overrideList;
    }

    private static List<BakedQuad> bakeItem(TextureAtlasSprite ... sprites) {
        return CosmicBakedModel.bakeItem(Transformation.m_121093_(), sprites);
    }

    private static List<BakedQuad> bakeItem(Transformation state, TextureAtlasSprite ... sprites) {
        LambdaUtils.checkArgument((Object)sprites, (String)"Sprites must not be Null or empty!", ArrayUtils::isNullOrContainsNull);
        LinkedList<BakedQuad> quads = new LinkedList<BakedQuad>();
        for (int i = 0; i < sprites.length; ++i) {
            TextureAtlasSprite sprite = sprites[i];
            List unbaked = ITEM_MODEL_GENERATOR.m_111638_(i, "layer" + i, sprite);
            for (BlockElement element : unbaked) {
                for (Map.Entry entry : element.f_111310_.entrySet()) {
                    quads.add(FACE_BAKERY.m_111600_(element.f_111308_, element.f_111309_, (BlockElementFace)entry.getValue(), sprite, (Direction)entry.getKey(), (ModelState)SimpleModelState.IDENTITY, element.f_111311_, element.f_111312_, new ResourceLocation("avaritia", "dynamic")));
                }
            }
        }
        return quads;
    }
}

